/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public class NameUtils {
    @Nonnull
    public static String toConstantCase(@Nonnull String s2) {
        return NameUtils.fromCamel(s2, true);
    }

    @Nonnull
    public static String toUnderscoreCase(@Nonnull String s2) {
        return NameUtils.fromCamel(s2, false);
    }

    @Nonnull
    private static String fromCamel(@Nonnull String s2, boolean toUpper) {
        Preconditions.checkNotNull(s2);
        int n = s2.length();
        StringBuilder sb = new StringBuilder(n + 3);
        int lastT = 0;
        for (int i = 0; i < n; ++i) {
            char c = s2.charAt(i);
            int t = Character.getType(c);
            switch (t) {
                case 2: {
                    if (toUpper) {
                        sb.append(Character.toUpperCase(c));
                        break;
                    }
                    sb.append(c);
                    break;
                }
                case 1: {
                    if (i > 0 && (lastT != 1 || i < n - 1 && !Character.isUpperCase(s2.charAt(i + 1)))) {
                        sb.append('_');
                    }
                    if (toUpper) {
                        sb.append(c);
                        break;
                    }
                    sb.append(Character.toLowerCase(c));
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            lastT = t;
        }
        return sb.toString();
    }

    @Nonnull
    public static String toCamelCaseCap(@Nonnull String s2) {
        return NameUtils.camelCase(s2, true);
    }

    @Nonnull
    public static String toCamelCase(@Nonnull String s2) {
        return NameUtils.camelCase(s2, false);
    }

    @Nonnull
    private static String camelCase(@Nonnull String s2, boolean cap) {
        Preconditions.checkNotNull(s2);
        boolean up = cap;
        int n = s2.length();
        StringBuilder sb = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            char c = s2.charAt(i);
            if (c == '_' && i < n - 1) {
                up = true;
                continue;
            }
            if (up) {
                sb.append(Character.toUpperCase(c));
                up = false;
                continue;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }
}

